#include "menu.h"

Menu::Menu(int scene) {
	switch(scene) {
	case MAINMENU:
		numItems = 4;
		itemName[0] = "New Game";
		itemName[1] = "High Scores";
		itemName[2] = "Difficulty: Normal";
		itemName[3] = "Quit";
		break;
	default:
		numItems = 2;
		itemName[0] = "YES";
		itemName[1] = "NO";
		break;
	}
	cursor = 0;
}

int Menu::getCursor() {
	return cursor;
}

int Menu::getNumItems() {
	return numItems;
}

string Menu::getItem(int id) {
	return itemName[id];
}

void Menu::setCursor(int n_cursor) {
	cursor = n_cursor;
	while(cursor >= numItems) {
		cursor -= numItems;
	}
	while(cursor < 0) {
		cursor += numItems;
	}
}

void Menu::setItem(int id, string n_item) {
	itemName[id] = n_item;
}
