#ifndef DISPLAY_H
#define DISPLAY_H

#include "include.h"
#include "controller.h"
#include "being.h"
#include "organizer.h"

class Controller;
class Being;

class Display {
public:
	Display();
	void glEnable2D();
	void glDisable2D();

	void BuildLists();
	SDL_Surface* LoadBMP( char *Filename );
	int LoadGLTextures();
	void BuildFont();
	void KillFont();
	void KillParticles();
	void glPrint(GLint x, GLint y, GLfloat scale, bool set, bool center, const char *string, ...);
	bool InitGL(SDL_Surface *S);

	float getRotate();
	float getXCamera();
	float getYCamera();

	void moveCamera(float x, float y);
	void setCamera(float x, float y);
	void setSeenCamera(float x, float y);
	void pivotCamera(float rot);
	void tiltCamera(float rot);

	void drawTile(Controller *c, int x, int y);
	void draw(Controller c);
	void draw(Being b, bool selected);
	void draw(Organizer o);
	void drawStats(Controller c);
private:
	GLUquadricObj *quadratic;

	int list;
	GLuint texture[NUM_TEXTURES];
	GLuint base;					// Base Display List For The Font
	float xCamera, yCamera, tilt;
	float xTarget, yTarget, targetTilt;			//Target positions of camera
	float lightposition[4];
	float lightDiffuse[4];

	float rotate, targetRotate;
	float cursorSpin;
	float subCursorHeight;
	bool showDamage;
};

#endif
